<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 27.01.14 11:21
 */

namespace VM\AdminBundle\Services;


use Doctrine\ORM\EntityManager;
use VM\ApiBundle\Entity\RDFExport;

class RDFExportGeneratorService
{

    /**
     * @var EntityManager
     */
    protected $EntityManager;

    /**
     * @var string
     */
    protected $rdfNamespace;

    protected $iterator = 0;

    public function __construct(EntityManager $EntityManager, $rdfNamespace)
    {
        $this->EntityManager = $EntityManager;
        $this->rdfNamespace = $rdfNamespace;
    }

    public function objToRDF($RDFGraph,$data,$Res)
    {
        if(gettype($data) == 'object') {$data = (array)$data;}
        foreach($data as $key=>$value)
        {
            $this->iterator++;
            if(gettype($value) != 'object' && gettype($value) != 'array')
            {
                $val = $value;
                if(gettype($val) == 'integer' || gettype($val) == 'float') {$val = (string)round($value, 2);}
                $RDFGraph->add($Res, 'pole:'.$key, $val);
            }
            else
            {
                if(empty($value))
                {
                    $RDFGraph->add($Res, 'pole:'.$key, '');
                }
                else
                {
                    $Res2 = $RDFGraph->resource($key.'_'.$this->iterator);
                    $RDFGraph->addResource($Res,'pole:'.$key,$Res2);
                    $RDFGraph =  $this->objToRDF($RDFGraph,$value,$Res2);
                }
            }
        }
        return $RDFGraph;
    }

    public function generateRDFExportOfSimpleFinancialReport($data, $company, $round)
    {
        \EasyRdf_Namespace::set('grabiz', $this->rdfNamespace);
        \EasyRdf_Namespace::set('rok', 'rok');
        \EasyRdf_Namespace::set('pole', 'pole');
        $RDFGraph = new \EasyRdf_Graph();
        $exportData = '';

        $arrayData = (array)$data;
        foreach($arrayData as $key => $value)
        {
            if(!is_array($value))
            {
                if(is_string($value))
                {
                    $Res = $RDFGraph->resource($key);
                    $RDFGraph->add($Res, 'pole:'.$key, (string)round($value, 2));
                }
                else
                {
                    $valueArray = (array)$value;
                    foreach($valueArray as $innerKey => $innerValue)
                    {
                        $Res = $RDFGraph->resource($key.'_'.$innerKey);
                        foreach($innerValue as $k => $v)
                        {
                            $RDFGraph->add($Res, 'rok:'.$k, (string)round($v, 2));
                        }
                    }
                }
            }
            else
            {
                $Res = $RDFGraph->resource($key);
                foreach($value as $k => $v)
                {
                    $RDFGraph->add($Res, 'rok:'.$k, (string)round($v, 2));
                }
            }

        }

        $exportData = $RDFGraph->serialise('turtle');

        $this->saveGeneratedRDFSimpleFinancialReport($exportData, 'simple_financial_report', $company, $round);
    }

    protected function saveGeneratedRDFSimpleFinancialReport($exportData, $exportType, $company, $round)
    {
        $exportsRepo = $this->EntityManager->getRepository('VMApiBundle:RDFExport');
        $Export = $exportsRepo->findOneBy(array('company' => $company, 'round' => $round));
        if(empty($Export))
        {
            $Export = new RDFExport();
        }

        $Export->setCompany($company);
        $Export->setRound($round);
        $Export->setCreateAt(new \DateTime());
        $Export->setExportType($exportType);
        try
        {
            $Export->setExportData($exportData);
        }
        catch(\Exception $e)
        {
            $Export->setExportData(json_encode($exportData));
        }

        $this->EntityManager->persist($Export);
        $this->EntityManager->flush();
    }
} 